#include <iostream>
#include <vector>
#include <string>
#include <algorithm>
#include <unordered_map>

using namespace std;
int main()
{
    long long n;
    vector<long long> x_values;
    vector<long long> y_values;
    unordered_map<long long, long long> sum_diag;
    unordered_map<long long, long long> diff_diag;
    unordered_map<long long, vector<pair<long long, long long>>> x_count;
    unordered_map<long long, vector<pair<long long, long long>>> y_count;
    long long number_of_pairs = 0;
    cin >> n;
    for (long long i = 0; i < n; i++)
    {
        long long x, y;
        cin >> x >> y;
        x_values.push_back(x);
        y_values.push_back(y);
    }
    for (long long i = 0; i < n; i++)
    {
        sum_diag[x_values[i] + y_values[i]]++;
        diff_diag[x_values[i] - y_values[i]]++;
        x_count[x_values[i]].push_back({x_values[i], y_values[i]});
        y_count[y_values[i]].push_back({x_values[i], y_values[i]});
    }
    for (auto &pair : sum_diag)
    {
        long long count = pair.second;
        number_of_pairs += count * (count - 1);
    }
    for (auto &pair : diff_diag)
    {
        long long count = pair.second;
        number_of_pairs += count * (count - 1);
    }

    for (auto &entry : x_count)
    {
        long long even_y = 0, odd_y = 0;
        for (auto &pt : entry.second)
        {
            if (pt.second % 2 == 0)
            {
                even_y++;
            }
            else
            {
                odd_y++;
            }
        }
        number_of_pairs += even_y * (even_y - 1) / 2 + odd_y * (odd_y - 1) / 2;
    }

    for (auto &entry : y_count)
    {
        long long even_x = 0, odd_x = 0;
        for (auto &pt : entry.second)
        {
            if (pt.first % 2 == 0)
            {
                even_x++;
            }
            else
            {
                odd_x++;
            }
        }
        number_of_pairs += even_x * (even_x - 1) / 2 + odd_x * (odd_x - 1) / 2;
    }

    cout << number_of_pairs;
}